<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/providers.json";
$providers = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

// --- Tambah Provider ---
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST["action"] === "add") {
    $providers[] = [
        "href"  => $_POST["href"],
        "img"   => $_POST["img"],
        "long"  => $_POST["long"],
        "short" => $_POST["short"]
    ];
    file_put_contents($file, json_encode($providers, JSON_PRETTY_PRINT));
    header("Location: provider_edit?msg=" . urlencode("Provider berhasil ditambahkan!"));
    exit;
}

// --- Edit Provider ---
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST["action"] === "edit") {
    $id = intval($_POST["id"]);
    if (isset($providers[$id])) {
        $providers[$id]["href"]  = $_POST["href"];
        $providers[$id]["img"]   = $_POST["img"];
        $providers[$id]["long"]  = $_POST["long"];
        $providers[$id]["short"] = $_POST["short"];
        file_put_contents($file, json_encode($providers, JSON_PRETTY_PRINT));
    }
    header("Location: provider_edit?msg=" . urlencode("Provider berhasil diperbarui!"));
    exit;
}

// --- Hapus Provider ---
if (isset($_GET["delete"])) {
    $id = intval($_GET["delete"]);
    if (isset($providers[$id])) {
        unset($providers[$id]);
        $providers = array_values($providers);
        file_put_contents($file, json_encode($providers, JSON_PRETTY_PRINT));
    }
    header("Location: provider_edit?msg=" . urlencode("Provider berhasil dihapus!"));
    exit;
}

$msg = $_GET["msg"] ?? "";
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Kelola Provider</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    function enableEdit(id) {
      document.getElementById("row-view-" + id).classList.add("hidden");
      document.getElementById("row-edit-" + id).classList.remove("hidden");
    }
    function cancelEdit(id) {
      document.getElementById("row-view-" + id).classList.remove("hidden");
      document.getElementById("row-edit-" + id).classList.add("hidden");
    }
    function previewLogo(input, id) {
      const url = input.value;
      const img = document.getElementById("preview-" + id);
      img.src = url;
    }
  </script>
</head>
<body class="p-6 bg-gray-100">
  <h1 class="text-xl font-bold mb-4">Kelola Provider</h1>

  <?php if (!empty($msg)): ?>
    <script>
      document.addEventListener("DOMContentLoaded", function () {
        Swal.fire({
          toast: true,
          position: 'top-end',
          icon: 'success',
          title: <?php echo json_encode($msg); ?>,
          showConfirmButton: false,
          timer: 2500,
          timerProgressBar: true
        });
      });
    </script>
  <?php endif; ?>

  <!-- Form Tambah -->
  <div class="bg-white p-4 rounded shadow mb-6">
    <h2 class="text-lg font-semibold mb-3">Tambah Provider</h2>
    <form method="post" class="space-y-3">
      <input type="hidden" name="action" value="add">
      <input type="text" name="href" placeholder="Link (href)" class="border p-2 rounded w-full" required>
      <input type="text" name="img" placeholder="URL Logo" class="border p-2 rounded w-full" required>
      <input type="text" name="long" placeholder="Nama Panjang" class="border p-2 rounded w-full" required>
      <input type="text" name="short" placeholder="Nama Pendek" class="border p-2 rounded w-full" required>
      <button class="bg-blue-600 text-white px-4 py-2 rounded">Tambah Provider</button>
    </form>
    <a href="dashboard" class="inline-block mt-4 px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-500">⬅ Kembali ke Dashboard</a>
  </div>

  <!-- Tabel Provider -->
  <div class="bg-white p-4 rounded shadow">
    <h2 class="text-lg font-semibold mb-3">Daftar Provider</h2>
    <table class="w-full border-collapse">
      <thead class="bg-gray-200">
        <tr>
          <th class="p-2 border">Logo</th>
          <th class="p-2 border">Nama Panjang</th>
          <th class="p-2 border">Nama Pendek</th>
          <th class="p-2 border">Link</th>
          <th class="p-2 border">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($providers as $i => $p): ?>
          <!-- Tampilan normal -->
          <tr id="row-view-<?php echo $i; ?>" class="hover:bg-gray-50">
            <td class="border p-2"><img src="<?php echo $p['img']; ?>" class="h-10"></td>
            <td class="border p-2"><?php echo htmlspecialchars($p['long']); ?></td>
            <td class="border p-2"><?php echo htmlspecialchars($p['short']); ?></td>
            <td class="border p-2"><?php echo htmlspecialchars($p['href']); ?></td>
            <td class="border p-2 space-x-2">
              <button type="button" onclick="enableEdit(<?php echo $i; ?>)" class="bg-yellow-500 text-white px-3 py-1 rounded">Edit</button>
              <a href="?delete=<?php echo $i; ?>" 
                 class="btn-delete bg-red-600 text-white px-3 py-1 rounded"
                 data-url="?delete=<?php echo $i; ?>">Hapus</a>
            </td>
          </tr>

          <!-- Mode edit -->
          <tr id="row-edit-<?php echo $i; ?>" class="hidden bg-gray-50">
            <form method="post">
              <input type="hidden" name="action" value="edit">
              <input type="hidden" name="id" value="<?php echo $i; ?>">
              <td class="border p-2">
                <input type="text" name="img" value="<?php echo htmlspecialchars($p['img']); ?>" 
                       oninput="previewLogo(this, <?php echo $i; ?>)" 
                       class="border p-1 rounded w-40 mb-1">
                <img id="preview-<?php echo $i; ?>" src="<?php echo $p['img']; ?>" class="h-10 mt-1">
              </td>
              <td class="border p-2"><input type="text" name="long" value="<?php echo htmlspecialchars($p['long']); ?>" class="border p-1 rounded w-40"></td>
              <td class="border p-2"><input type="text" name="short" value="<?php echo htmlspecialchars($p['short']); ?>" class="border p-1 rounded w-24"></td>
              <td class="border p-2"><input type="text" name="href" value="<?php echo htmlspecialchars($p['href']); ?>" class="border p-1 rounded w-40"></td>
              <td class="border p-2 space-x-2">
                <button type="submit" class="bg-green-600 text-white px-3 py-1 rounded">Simpan</button>
                <button type="button" onclick="cancelEdit(<?php echo $i; ?>)" class="bg-gray-600 text-white px-3 py-1 rounded">Batal</button>
              </td>
            </form>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($providers)): ?>
          <tr><td colspan="5" class="text-center p-4">Belum ada provider</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <script>
    // Konfirmasi hapus pakai SweetAlert2
    document.querySelectorAll('.btn-delete').forEach(btn => {
      btn.addEventListener('click', function (e) {
        e.preventDefault();
        let url = this.getAttribute('data-url');
        Swal.fire({
          title: 'Yakin hapus?',
          text: "Provider ini akan dihapus permanen!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Ya, hapus!',
          cancelButtonText: 'Batal'
        }).then((result) => {
          if (result.isConfirmed) {
            window.location.href = url;
          }
        });
      });
    });
  </script>
</body>
</html>
