<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/links.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([
        "alt1" => "",
        "alt2" => "",
        "livechat" => "",
        "whatsapp" => "",
        "main" => ""
    ], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true);

$msg = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $data["alt1"] = $_POST["alt1"];
    $data["alt2"] = $_POST["alt2"];
    $data["livechat"] = $_POST["livechat"];
    $data["whatsapp"] = $_POST["whatsapp"];
    $data["main"] = $_POST["main"];
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    $msg = "Link alternatif berhasil diperbarui!";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Link Alternatif</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4">🔗 Kelola Link Alternatif</h2>

    <?php if (!empty($msg)): ?>
        <div class="mb-4 p-3 rounded bg-green-100 text-green-800 font-medium">
            <?php echo $msg; ?>
        </div>
    <?php endif; ?>

    <div class="bg-white p-6 rounded shadow max-w-xl">
        <form method="post" class="space-y-4">
            <div>
                <label class="font-medium">Link Alternatif 1</label>
                <input type="text" name="alt1" value="<?php echo htmlspecialchars($data["alt1"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div>
                <label class="font-medium">Link Alternatif 2</label>
                <input type="text" name="alt2" value="<?php echo htmlspecialchars($data["alt2"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div>
                <label class="font-medium">Livechat</label>
                <input type="text" name="livechat" value="<?php echo htmlspecialchars($data["livechat"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div>
                <label class="font-medium">WhatsApp</label>
                <input type="text" name="whatsapp" value="<?php echo htmlspecialchars($data["whatsapp"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div>
                <label class="font-medium">Link MAIN</label>
                <input type="text" name="main" value="<?php echo htmlspecialchars($data["main"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div class="flex flex-wrap gap-3 pt-2">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">💾 Simpan</button>
                <a href="dashboard" class="px-4 py-2 bg-gray-500 text-white rounded hover:bg-gray-600">⬅ Kembali</a>
            </div>
        </form>

        <!-- Preview Link -->
        <div class="mt-6">
            <h3 class="text-lg font-semibold mb-3">👀 Preview Link</h3>
            <div class="space-y-2">
                <?php if (!empty($data["alt1"])): ?>
                    <a href="<?php echo $data["alt1"]; ?>" target="_blank" class="block px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-500">🔗 Link Alternatif 1</a>
                <?php endif; ?>
                <?php if (!empty($data["alt2"])): ?>
                    <a href="<?php echo $data["alt2"]; ?>" target="_blank" class="block px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-500">🔗 Link Alternatif 2</a>
                <?php endif; ?>
                <?php if (!empty($data["livechat"])): ?>
                    <a href="<?php echo $data["livechat"]; ?>" target="_blank" class="block px-4 py-2 bg-green-600 text-white rounded hover:bg-green-500">💬 Livechat</a>
                <?php endif; ?>
                <?php if (!empty($data["whatsapp"])): ?>
                    <a href="<?php echo $data["whatsapp"]; ?>" target="_blank" class="block px-4 py-2 bg-green-700 text-white rounded hover:bg-green-600">📱 WhatsApp</a>
                <?php endif; ?>
                <?php if (!empty($data["main"])): ?>
                    <a href="<?php echo $data["main"]; ?>" target="_blank" class="block px-4 py-2 bg-blue-700 text-white rounded hover:bg-blue-600">🏠 Link MAIN</a>
                <?php endif; ?>
            </div>
        </div>
    </div>

</body>
</html>
